#include <bits/stdc++.h>

using namespace std;

void ispis(int **ploca) {
  for (int i = 0; i < 4; i++) {
    for (int j = 0; j < 4; j++) {
      cerr << ploca[i][j] << ' ';
    }
    cerr << '\n';
  }
  cerr << '\n';
}

void ispis_potezi(int potezi, int n) {
  for (int i = 0; i < n; i++) { 
    if (!(potezi & (1 << (i * 2))) && !(potezi & (1 << (i * 2 + 1)))) 
      cerr << 'L';
    else if (!(potezi & (1 << (i * 2))) && (potezi & (1 << (i * 2 + 1))))
      cerr << 'R';
    else if ((potezi & (1 << (i * 2))) && !(potezi & (1 << (i * 2 + 1))))
      cerr << 'U';
    else 
      cerr << 'D';
  }
  cerr << "\n\n";
}

void rotiraj_ulijevo(int **ploca) {
  for (int i = 0; i < 4 / 2; i++) {
    for (int j = i; j < 4 - i - 1; j++) {
      int temp = ploca[i][j];
      ploca[i][j] = ploca[j][4 - i - 1];
      ploca[j][4 - i - 1] = ploca[4 - i - 1][4 - j - 1];
      ploca[4 - i - 1][4 - j - 1] = ploca[4 - j - 1][i];
      ploca[4 - j - 1][i] = temp;
    }
  }
}

void rotiraj_udesno(int **ploca) {
  for (int i = 0; i < 4 / 2; i++) {
    for (int j = i; j < 4 - i - 1; j++) {
      int temp = ploca[i][j];
      ploca[i][j] = ploca[4 - j - 1][i];
      ploca[4 - j - 1][i] = ploca[4 - i - 1][4 - j - 1];
      ploca[4 - i - 1][4 - j - 1] = ploca[j][4 - i - 1];
      ploca[j][4 - i - 1] = temp;
    }
  }
}

void zrcali_okomito(int **ploca) {
  for (int i = 0; i < 4; i++) {
    for (int j = 0; j < 4 / 2; j++) {
      int temp = ploca[i][j];
      ploca[i][j] = ploca[i][4 - j - 1];
      ploca[i][4 - j - 1] = temp;
    }
  }
}

void lijevo(int **ploca) {
  for (int i = 0; i < 4; i++) {
    int t = 0;
    int temp[4] = {0};
    for (int j = 0; j < 4; j++) {
      if (ploca[i][j] == 0) continue;
      temp[t] = ploca[i][j];
      t++;
    }

    //ispis(ploca);

    for (int j = 0; j < 4; j++) ploca[i][j] = temp[j];

    //ispis(ploca);

    int y = -1;
    while (++y < 3) {
      if (ploca[i][y] == ploca[i][y + 1]) {
        ploca[i][y] *= 2;
        ploca[i][y + 1] = 0;
        y++;
      }
    }

    //ispis(ploca);

    int t2 = 0;
    int temp2[4] = {0};
    for (int j = 0; j < 4; j++) {
      if (ploca[i][j] == 0) continue;
      temp2[t2] = ploca[i][j];
      t2++;
    }
    
    for (int j = 0; j < 4; j++) ploca[i][j] = temp2[j];
  
    //ispis(ploca);
    //cerr << "###\n";
  }
}

void desno(int **ploca) {
  zrcali_okomito(ploca);
  lijevo(ploca); 
  zrcali_okomito(ploca);
}

void gore(int **ploca) {
  rotiraj_ulijevo(ploca);
  lijevo(ploca);
  rotiraj_udesno(ploca);
}

void dolje(int **ploca) {
  rotiraj_ulijevo(ploca);
  desno(ploca);
  rotiraj_udesno(ploca);
}

bool postavi_broj(int b, int x, int y, int **ploca) {
  if (ploca[x][y]) return false;
  ploca[x][y] = b;
  return true;
}

void kopiraj(int **kopija, int **ploca) {
  for (int i = 0; i < 4; i++) {
    for (int j = 0; j < 4; j++) {
      kopija[i][j] = ploca[i][j];
    }
  }
}

bool postoji2048(int **ploca) {
  for (int i = 0; i < 4; i++) {
    for (int j = 0; j < 4; j++) {
      if (ploca[i][j] == 2048) return true;
    }
  }

  return false;
}

void prebroji(int *trenutno, int **ploca) {
  for (int i = 0; i < 4; i++) {
    for (int j = 0; j < 4; j++) {
      if (!ploca[i][j]) continue;
      
      int x = 0;
      while (!((1 << (x + 1)) & ploca[i][j])) x++;
      trenutno[x]++;
    }
  }
}

bool bolja(int *trenutno, int *najbolje) {
  for (int i = 10; i >= 0; i--) {
    if (najbolje[i] > trenutno[i]) break;
    if (trenutno[i] > najbolje[i]) return true;
  }
  return false;
}

bool jednake(int *trenutno, int *najbolje) {
  for (int i = 10; i >= 0; i--) {
    if (najbolje[i] != trenutno[i]) return false;
  }
  return true;
}

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(nullptr);

  int **pocetno = new int*[4];
  int **kopija = new int*[4];
  for (int i = 0; i < 4; i++) {
    pocetno[i] = new int[4];
    kopija[i] = new int[4];
  }

  for (int i = 0; i < 4; i++) {
    for (int j = 0; j < 4; j++) {
      cin >> pocetno[i][j];
    }
  }

  int n;
  cin >> n;

  int b[n], x[n], y[n];
  for (int i = 0; i < n; i++) {
    cin >> b[i] >> x[i] >> y[i];
    --x[i], --y[i];
  }

  int *najbolje = new int[11];

  for (int potezi = 0; potezi < (1 << (2 * n)); potezi++) {
    bool ok = true;
    int *trenutno = new int[11];
    kopiraj(kopija, pocetno);

    for (int i = 0; i < n; i++) {
      if (!(potezi & (1 << (i * 2))) && !(potezi & (1 << (i * 2 + 1)))) 
        lijevo(kopija);
      else if (!(potezi & (1 << (i * 2))) && (potezi & (1 << (i * 2 + 1))))
        desno(kopija);
      else if ((potezi & (1 << (i * 2))) && !(potezi & (1 << (i * 2 + 1))))
        gore(kopija);
      else 
        dolje(kopija);
     
      if (postoji2048(kopija)) break;

      if (!postavi_broj(b[i], x[i], y[i], kopija)) {
        ok = false;
        break;
      }
    }

    prebroji(trenutno, kopija);

    if (!ok) continue;
    if (bolja(trenutno, najbolje)) {
      najbolje = trenutno;

      //cerr << "### BOLJA ###\n";
      //ispis(kopija);
      //ispis_potezi(potezi, n);
    }

    if (jednake(trenutno, najbolje)) {
      //ispis(kopija);
      //ispis_potezi(potezi, n);
      //cerr << potezi << '\n';
    }
  }

  for (int i = 0; i < 11; i++) {
    cout << najbolje[i] << ' ';
  }
  cout << '\n';

  return 0;
}
